<?php

/**
 *
 * INDEXU
 * Copyright(C), Nicecoder, 2000-2006, All Rights Reserved.
 *
 * INDEXU(tm) is protected by Indonesia and International copyright laws.
 * Unauthorized use or distribution of INDEXU(tm) is strictly prohibited,
 * violators will be prosecuted. To obtain a license for using INDEXU(tm),
 * please register at Nicecoder home page at http://www.nicecoder.com
 *
 * Author:
 *    Dody Rachmat Wicaksono (dody@nicecoder.com)
 *    M. Zuber (zubby@nicecoder.com)
 *
 */

  /*===================================================
    ShowFormEditLink()
  ===================================================*/

  function ShowFormEditLink() {

    // vars global configuration
    global $category_separator, $theme_path;

    // vars url & form
    global $id;

    // vars messages
    global $msg;


    // generate custom field
    $links_obj                                    = new clsLink;
    $links_obj->table_name                        = "idx_link";
    $links_obj->category_table_name               = "idx_category";
    $links_obj->editor_table_name                 = "idx_editor";
    $links_obj->autogenerate_form_text            = $msg["00001"];
    $links_obj->autogenerate_form_textarea        = $msg["00002"];
    $links_obj->autogenerate_form_image           = $msg["00004"];
    $links_obj->autogenerate_form_file            = $msg["00006"];
    $links_obj->autogenerate_form_select          = $msg["00007"];
    $links_obj->autogenerate_form_multiselect     = $msg["00008"];
    $links_obj->autogenerate_form_checkbox        = $msg["00009"];
    $links_obj->autogenerate_form_radio           = $msg["00010"];
    $links_obj->autogenerate_form_date            = $msg["00011"];
    $links_obj->autogenerate_form_datetime        = $msg["00012"];
    $links_obj->autogenerate_form_template        = $theme_path . "custom_field_form_rows.html";
    $links_obj->template_file                     = $theme_path . "cp/editor_link_edit_form.html";
    $links_obj->Modify("display_form", $id, true, true);
  }


  /*===================================================
    ProcessFormEditLink()
  ===================================================*/

  function ProcessFormEditLink() {

    // vars global configuration
    global $category_separator, $theme_path;

    // vars url & form
    global $id, $link_id, $title, $url, $description, $cat, $contact_name, $email, $bid, $password, $reciprocal_url;

    // vars messages
    global $msg;

    // vars template
    global $error_msg;

    // verify input

    $title = $_POST["title"];

    if (empty($id))
      $id = $link_id;

    if (empty($title))
      $error_msg = $msg["20151"];
    elseif (empty($url))
      $error_msg = $msg["20152"];
    elseif (empty($cat))
      $error_msg = $msg["20158"];
    elseif (!empty($email) && !IsEmailAddress($email))
      $error_msg = $msg["20156"];
    elseif (!empty($bid) && !IsMoney($bid))
      $error_msg = $msg["20157"];

    if (empty($error_msg)) {
      $links_obj = new clsLink;
        $links_obj->table_name          = "idx_link";
      $links_obj->category_table_name = "idx_category";
      $links_obj->editor_table_name   = "idx_editor";
      $links_obj->user_table_name     = "idx_users";
      $modify_result                  = $links_obj->Modify("process_form", $link_id, true);

      // update updated flag
      $links_obj->UpdateUpdatedFlag();

      DisplayTemplate($theme_path . "cp/editor_link_edit_ok.html");
    }
    else
      ShowFormEditLink();
    }


  /*===================================================
    main
  ===================================================*/

  include "../application.php";

  AddFilter('validate_editor');
  RunPreFilter(__FILE__);
  
  if (empty($pflag)) {
    ShowFormEditLink();
  }
  elseif ($pflag == 'modify') {
    ProcessFormEditLink();
  }

  RunPostFilter(__FILE__);

?>